import bcrypt
import hmac

def hash_password(password):
    """Membuat hash dari password dengan salt rounds yang cukup."""
    return bcrypt.hashpw(password.encode(), bcrypt.gensalt(rounds=12)).decode()

def check_password(password, hashed_password):
    """Memeriksa password dengan hash menggunakan constant-time comparison."""
    return hmac.compare_digest(
        bcrypt.hashpw(password.encode(), hashed_password.encode()),
        hashed_password.encode()
    )
