from db import get_db_connection
import random
import string
import datetime

def getnasabah(nik):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT nik, nama, alamat, no_hp, email, aset, cabang FROM nasabah WHERE nik = %s", (nik,))
    result = cursor.fetchone()
    db.close()
    
    if result:
        return {
            "nik": result[0],
            "nama": result[1],
            "alamat": result[2],
            "no_hp": result[3],
            "email": result[4],
            "aset": result[5],
            "cabang": result[6]
        }
    else:
        return {"error": "Data pengguna tidak ditemukan!"}
    
def getsampah():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT jenis, satuan, harga_jual, gambar FROM sampah")
    result = cursor.fetchall()
    db.close()
    
    if result:
        return [
            {
                "jenis": row[0],
                "satuan": row[1],
                "hargajual": row[2],
                "gambar": row[3]
            }
            for row in result
        ]
    else:
        return {"error": "Data Sampah Kosong!"}

def getsetor(nik):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT jenis, satuan, jumlah, harga ,total, tanggal, cabang FROM setor_nasabah WHERE nik = %s", (nik,))
    result = cursor.fetchall()
    db.close()
    
    if result:
        return [
            {
                "jenis": row[0],
                "satuan": row[1],
                "jumlah": row[2],
                "harga": row[3],
                "total": row[4],
                "tanggal": row[5],
                "cabang": row[6]
            }
            for row in result
        ]
    else:
        return {"error": "Data Setor Kosong!"}

def gettarik(nik):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT cabang,jumlah,tanggal FROM tarik_nasabah WHERE nik = %s", (nik,))
    result = cursor.fetchall()
    db.close()
    
    if result:
        return [
            {
                "cabang": row[0],
                "jumlah": row[1],
                "tanggal": row[2]
            }
            for row in result
        ]
    else:
        return {"error": "Data Tarik Kosong!"}

def createkodetarik(nik, cabang, jumlah):
    """Membuat kode tarik unik dan menyimpannya ke database."""
    
    def generate_random_string(length=16):
        """Generate string acak 16 karakter (A-Z, 0-9)."""
        characters = string.ascii_uppercase + string.digits  # A-Z dan 0-9
        return ''.join(random.choices(characters, k=length))

    db = get_db_connection()
    cursor = db.cursor()

    try:
        while True:
            code = generate_random_string()
            
            # Gunakan EXISTS() untuk mempercepat query
            cursor.execute("SELECT EXISTS(SELECT 1 FROM code_tarik WHERE code = %s)", (code,))
            if not cursor.fetchone()[0]:  
                break  # Kode belum ada, keluar dari loop

        tanggal_expired = datetime.datetime.now() + datetime.timedelta(days=1)

        cursor.execute("""
            INSERT INTO code_tarik (code, nik, cabang, jumlah, tanggal_expired) 
            VALUES (%s, %s, %s, %s, %s)
        """, (code, nik, cabang, jumlah, tanggal_expired))

        db.commit()
        return {"message": "Kode berhasil dibuat!", "code": code}

    finally:
        db.close()  # Pastikan koneksi ditutup


def getkode(nik):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT code, cabang, jumlah, tanggal_expired FROM code_tarik WHERE nik = %s", (nik,))
    result = cursor.fetchall()
    db.close()
    
    if result:
        return [
            {
                "code": row[0],
                "cabang": row[1],
                "jumlah": int(row[2]),
                "tanggal_expired": row[3]
            }
            for row in result
        ]
    else:
        return {"error": "Data Tarik Kosong!"}
    

def getreport(nik):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute(
        "SELECT jenis, SUM(jumlah) AS jumlah_satuan, SUM(total) AS jumlah_total FROM setor_nasabah WHERE nik = %s GROUP BY jenis",
        (nik,)
    )

    data = cursor.fetchall()

    cursor.execute("SELECT SUM(total) AS jumlah_total FROM setor_nasabah WHERE nik = %s", (nik,))
    total_setor = cursor.fetchone()

    cursor.execute("SELECT SUM(jumlah) AS jumlah_total FROM tarik_nasabah WHERE nik = %s", (nik,))
    total_tarik = cursor.fetchone()

    db.close()

    # Jika data kosong, tetap return list kosong
    result_data = [
        {
            "jenis": row[0],
            "jumlah_satuan": int(row[1]) if row[1] else 0,
            "jumlah_total": row[2] if row[2] else 0.0
        }
        for row in data
    ] if data else []

    # Pastikan total_setor dan total_tarik tetap angka (tidak None)
    setor = total_setor[0] if total_setor and total_setor[0] is not None else 0.0
    tarik = total_tarik[0] if total_tarik and total_tarik[0] is not None else 0.0

    total = {
        "total_setor": setor,
        "total_tarik": tarik
    }
    
    return result_data, total  # Selalu mengembalikan dua nilai

    
def getcabang():
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT nama FROM admin")
    result = cursor.fetchall()
    db.close()
    
    if result:
        return [
            {
                "nama": row[0]
            }
            for row in result
        ]
    else:
        return {"error": "Data Cabang Kosong!"}
    
def getdatacabang(nama):
    db = get_db_connection()
    cursor = db.cursor()
    cursor.execute("SELECT nama, alamat, no_hp, email,logo FROM admin WHERE nama = %s", (nama,))
    result = cursor.fetchone()
    db.close()
    
    if result:
        return {
            "nama": result[0],
            "alamat": result[1],
            "no_hp": result[2],
            "email": result[3],
            "logo": result[4]
        }
    else:
        return {"error": "Data Cabang Tidak Ditemukan!"}