from flask import Flask, render_template, request, redirect, flash, jsonify, session, send_from_directory, abort
from flask_limiter import Limiter
from flask_limiter.util import get_remote_address
from werkzeug.utils import secure_filename
from nasabah import *
from induk import *
from cabang import *
from login import *
from jwt_auth import verify_jwt
from flask_cors import CORS
import os
from dotenv import load_dotenv
import imghdr

# Load variabel dari .env
load_dotenv()

UPLOAD_KTP_FOLDER = os.getenv("UPLOAD_KTP_FOLDER")
UPLOAD_SAMPAH_FOLDER =  os.getenv("UPLOAD_SAMPAH_FOLDER")
UPLOAD_LOGO_FOLDER =  os.getenv("UPLOAD_LOGO_FOLDER")

app = Flask(__name__)
app.secret_key = os.getenv("SECRET_KEY")  # Mengambil dari .env

app.config['UPLOAD_KTP_FOLDER'] = UPLOAD_KTP_FOLDER
app.config['UPLOAD_SAMPAH_FOLDER'] = UPLOAD_SAMPAH_FOLDER
app.config['UPLOAD_LOGO_FOLDER'] = UPLOAD_LOGO_FOLDER
CORS(app)  # Mengizinkan akses API dari frontend


# Router Home dan Login
@app.route("/")
def home():
    return render_template("index.html")

@app.route("/login", methods=["GET", "POST"])
def login():
    """Halaman login untuk Admin & Nasabah dengan keamanan yang lebih baik."""
    
    if request.method == "POST":
        user = request.form.get("user", "").strip()
        password = request.form.get("pass", "").strip()

        if not user or not password:
            flash("Username dan password tidak boleh kosong!", "danger")
            return redirect("/login")

        # Bersihkan sesi sebelum login baru
        session.clear()

        # Coba login sebagai admin
        response = login_admin(user, password)
        if "error" in response:
            # Jika gagal, coba login sebagai nasabah
            response = login_user(user, password)
            if "error" in response:
                flash("Username atau password salah!", "danger")
                return redirect("/login")  # Redirect ke halaman login jika gagal

        # Jika login berhasil, set sesi JWT
        session["jwt"] = response.get("token")

        # Redirect sesuai level pengguna
        if response.get("level") == "induk":
            return redirect("/admininduk")
        elif response.get("level") == "cabang":
            return redirect("/admin")
        else:
            return redirect("/nasabah")

    return render_template("login.html")

ALLOWED_EXTENSIONS = {"png", "jpg", "jpeg"}

def allowed_file(filename):
    """Cek apakah ekstensi file yang diunggah aman"""
    return '.' in filename and filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS

# Router Nasabah
@app.route("/register", methods=["GET", "POST"])
def register():
    """Registrasi Nasabah"""
    data = getalladmin()
    page = request.args.get('page', 'register')  # Default halaman

    if request.method == "POST":
        nik = request.form["nik"]
        nama = request.form["nama"]
        alamat = request.form["alamat"]
        email = request.form["email"]
        nohp = request.form["nohp"]
        password = request.form["pass"]
        file = request.files['foto_ktp']
        cabang = request.form["cabang"]

        if file and allowed_file(file.filename):
            # Cegah path traversal attack
            filename = secure_filename(f"ktp_{nik}.jpg")
            file_path = os.path.join(app.config['UPLOAD_KTP_FOLDER'], filename)

            # Simpan file sementara dulu untuk validasi
            temp_path = file_path + ".tmp"
            file.save(temp_path)

            # Validasi apakah benar-benar gambar
            if imghdr.what(temp_path) not in ALLOWED_EXTENSIONS:
                os.remove(temp_path)  # Hapus file berbahaya
                flash("File bukan gambar yang valid!", "danger")
                return redirect("/register")

            # Pindahkan ke path final setelah validasi
            os.rename(temp_path, file_path)

        response = register_user(nik, nama, nohp, alamat, email, password, file_path, cabang)
        if "error" in response:
            flash(response["error"])
            return redirect("/register")

        flash("Registrasi berhasil, silakan login!")
        return redirect("/login")

    if page == "register":
        return render_template("register.html", data=list(enumerate(data)))
    else:
        return render_template("register.html", data=list(enumerate(data)), page=page)
    
@app.route("/buat_kode", methods=["GET", "POST"])
def buat_kode():
    user_data = verify_session()
    if not user_data or user_data["level"] != "nasabah":
        flash("Anda harus login sebagai nasabah!", "error")
        return redirect("/login")
    
    data = getnasabah(user_data["id"])
    data_cabang = getdatacabang(data["cabang"])
    user_data["saldo"] = data["aset"] or 0.0

    if request.method == "POST":
        cabang = request.form["cabang"]
        jumlah = request.form["jumlah"]
        message = createkodetarik(user_data["id"], cabang, jumlah)


        if message and "berhasil" in str(message).lower():
            flash("Code berhasil dibuat!", "success")
        else:
            flash("Code gagal dibuat!", "error")

        return redirect("/nasabah?page=tarik-saldo")

    return render_template("buat-kode.html", user_data=user_data, cabang=data_cabang)
@app.route("/nasabah")
def nasabah():
    """Dashboard Nasabah"""
    user_data = verify_session()
    if not user_data or user_data["level"] != "nasabah":
        flash("Anda harus login sebagai nasabah!")
        return redirect("/login")

    data = []  # Pastikan data tidak kosong sebelum digunakan
    data = getnasabah(user_data["id"])
    print(data)
    print(data["cabang"])

    data_cabang = getdatacabang(data["cabang"])
    print(data_cabang)

    user_data["saldo"] = data["aset"] or 0
    page = request.args.get('page', 'data-nasabah')  # Default halaman
    
     # Ambil data sesuai dengan halaman
    if page == 'data-nasabah':
        return render_template("data-nasabah.html", user_data=user_data, page=page, data=data, cabang=data_cabang)
    
    elif page == 'tarik-saldo':    
        data = getkode(user_data["id"])
        print(data)
        return render_template("tarik-saldo.html", user_data=user_data, page=page, data=list(enumerate(data)), cabang=data_cabang)
    
    elif page == 'data-sampah-n':
        data = getsampah()
        return render_template("view-sampah-n.html", user_data=user_data, page=page, data=list(enumerate(data)),cabang = data_cabang)
    
    elif page == 'histori-setor':
        data = getsetor(user_data["id"])
        return render_template("histori-setor.html", user_data=user_data, page=page, data=list(enumerate(data)),cabang = data_cabang)
    
    elif page == 'histori-tarik':
        data = gettarik(user_data["id"])
        return render_template("histori-tarik.html", user_data=user_data, page=page, data=list(enumerate(data)), cabang= data_cabang)
    
    elif page == 'grafik-nasabah':
        data,total = getreport(user_data["id"])
        data = data or []
        for d in data:
            d["jumlah_satuan"] = d["jumlah_satuan"] or 0
            d["jumlah_total"] = d["jumlah_total"] or 0.0

        total["total_setor"] = total["total_setor"] or 0.0
        total["total_tarik"] = total["total_tarik"] or 0.0

        return render_template("grafik-nasabah.html", user_data=user_data, page=page, data=list(enumerate(data)),total=total, cabang= data_cabang)
    
    else:
        # print(data_cabang)
        return render_template("data-nasabah.html", user_data=user_data, page=page, data=list(enumerate(data)), cabang=data_cabang)

# Router Admin Pusat
@app.route("/register-admincabang", methods=["GET", "POST"])
def register_admincabang():
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    """Registrasi Admin Cabang"""
    if request.method == "POST":
        try:
            nama = request.form["nama"]
            alamat = request.form["alamat"]
            email = request.form["email"]
            nohp = request.form["no_hp"]
            password = request.form["pass"]
            file = request.files['logo']

            if file and allowed_file(file.filename):
                # Cegah path traversal attack
                filename = secure_filename(f"logo_{nama}.jpg")
                file_path = os.path.join(app.config['UPLOAD_LOGO_FOLDER'], filename)

                # Simpan file sementara dulu untuk validasi
                temp_path = file_path + ".tmp"
                file.save(temp_path)

                # Validasi apakah benar-benar gambar
                if imghdr.what(temp_path) not in ALLOWED_EXTENSIONS:
                    os.remove(temp_path)  # Hapus file berbahaya
                    flash("File bukan gambar yang valid!", "danger")
                    return redirect("/register")

                # Pindahkan ke path final setelah validasi
                os.rename(temp_path, file_path)

            # Pastikan parameter sesuai urutan di register_cabang(nama, alamat, nohp, email, password)
            response = register_cabang(nama, alamat, nohp, email, password, file_path)

            if "error" in response:
                flash(response["error"], "danger")
                return redirect("/admininduk?page=data-cabang")

            flash("Registrasi berhasil, silakan login!", "success")
            return redirect("/admininduk?page=data-cabang")

        except KeyError:
            flash("Terjadi kesalahan dalam pengisian form.", "danger")
            return redirect("/admininduk?page=data-cabang")

    logo = f"/{getdatacabang(user_data['nama'])['logo']}"
    return render_template("register-admincabang.html", user_data=user_data, logo=logo)
@app.route("/edit-cabang/<int:id>", methods=["GET", "POST"])
def edit_cabang(id):
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    if request.method == "POST":
        id_cabang = id
        nama = request.form["nama"]
        alamat = request.form["alamat"]
        nohp = request.form["nohp"]
        email = request.form["email"]
        level = request.form["level"]
        response = updateadmin(id_cabang, nama, alamat, nohp, email, level)

        if "error" in response:
            flash(response["error"], "danger")
            return redirect("/admininduk?page=data-cabang")
        else:
            flash("Data cabang berhasil diubah!", "success")
            if user_data["id"] == id:
                return redirect("/logout")

        return redirect("/admininduk?page=data-cabang")

    data = getadmin(id)
    logo = f"/{getdatacabang(user_data['nama'])['logo']}"
    return render_template("edit-cabang.html", user_data=user_data, data=data, logo=logo)
@app.route("/delete-cabang/<int:id>", methods=["POST"])
def delete_cabang(id):
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    data = getadmin(id)


    response = deleteadmin(id)
    if "error" in response:
        flash(response["error"], "danger")
        return redirect("/admininduk?page=data-cabang")
    else:
        flash("Data cabang berhasil dihapus!", "success")
        return redirect("/admininduk?page=data-cabang")
@app.route("/edit-nasabah/<string:id>", methods=["GET", "POST"])
def edit_nasabah(id):
    user_data = verify_session()
    if not user_data or user_data["level"] not in ["induk", "cabang"]:
        abort(404)

    if request.method == "POST":
        id_nasabah = id
        nama = request.form["nama"]
        alamat = request.form["alamat"]
        nohp = request.form["nohp"]
        email = request.form["email"]
        response = updatenasabah(id_nasabah, nama, nohp, alamat, email)

        if "error" in response:
            if user_data["level"] == "induk":
                flash(response["error"], "danger")
                return redirect("/admininduk?page=data-nasabah-a")
            else:
                flash(response["error"], "danger")
                return redirect("/admin?page=data-nasabah-c")
        else:
            flash("Data nasabah berhasil diubah!", "success")

        if user_data["level"] == "induk":
            return redirect("/admininduk?page=data-nasabah-a")
        else:
            return redirect("/admin?page=data-nasabah-c")

    data = getnasabah(id)
    cabang_list = getalladmin()
    logo = f"/{getdatacabang(user_data['nama'])['logo']}"
    return render_template("edit-nasabah.html", user_data=user_data, data=data, cabang_list=cabang_list, logo=logo)
@app.route("/delete-nasabah/<string:id>", methods=["POST"])
def delete_nasabah(id):
    user_data = verify_session()
    if not user_data or user_data["level"] not in ["induk", "cabang"]:
        abort(404)

    response = deletenasabah(id)
    if "error" in response:
        if user_data["level"] == "induk":
            flash(response["error"], "danger")
            return redirect("/admininduk?page=data-nasabah-a")
        else:
            flash(response["error"], "danger")
            return redirect("/admin?page=data-nasabah-c")
    else:
        if user_data["level"] == "induk":
            flash("Data nasabah berhasil dihapus!", "success")
            return redirect("/admininduk?page=data-nasabah-a")
        else:
            flash("Data nasabah berhasil dihapus!", "success")
            return redirect("/admin?page=data-nasabah-c")
        
@app.route("/edit-sampah/<int:id>", methods=["GET", "POST"])
def edit_sampah(id):
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    if request.method == "POST":
        id_sampah = id
        jenis = request.form["jenis"]
        satuan = request.form["satuan"]
        harga_jual = request.form["harga_jual"]
        harga_induk = request.form["harga_induk"]
        response = updatesampah(id_sampah, jenis, satuan, harga_induk, harga_jual)

        if "error" in response:
            flash(response["error"], "danger")
            return redirect("/admininduk?page=data-sampah")
        else:
            flash("Data sampah berhasil diubah!", "success")

        return redirect("/admininduk?page=data-sampah")

    data = getsampahdetail(id)
    logo = f"/{getdatacabang(user_data['nama'])['logo']}"
    return render_template("edit-sampah.html", user_data=user_data, data=data, logo=logo)
@app.route("/delete-sampah/<int:id>", methods=["POST"])
def delete_sampah(id):
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    response = deletesampah(id)
    if "error" in response:
        flash(response["error"], "danger")
        return redirect("/admininduk?page=data-sampah")
    else:
        flash("Data sampah berhasil dihapus!", "success")
        return redirect("/admininduk?page=data-sampah")
@app.route("/tambah-sampah", methods=["GET", "POST"])
def tambah_sampah():
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    if request.method == "POST":
        jenis = request.form["jenis"]
        satuan = request.form["satuan"]
        harga_jual = request.form["harga_jual"]
        harga_induk = request.form["harga_induk"]
        file = request.files['gambar']

        if file and allowed_file(file.filename):
            # Cegah path traversal attack
            filename = secure_filename(f"sampah_{jenis}.jpg")
            file_path = os.path.join(app.config['UPLOAD_SAMPAH_FOLDER'], filename)

            # Simpan file sementara dulu untuk validasi
            temp_path = file_path + ".tmp"
            file.save(temp_path)

            # Validasi apakah benar-benar gambar
            if imghdr.what(temp_path) not in ALLOWED_EXTENSIONS:
                os.remove(temp_path)  # Hapus file berbahaya
                flash("File bukan gambar yang valid!", "danger")
                return redirect("/register")

            # Pindahkan ke path final setelah validasi
            os.rename(temp_path, file_path)

        response = addsampah(jenis, satuan, harga_induk, harga_jual, file_path)
        
        if "error" in response:
            flash(response["error"], "danger")
            return redirect("/admininduk?page=data-sampah")
        else:
            flash("Data sampah berhasil ditambahkan!", "success")

        return redirect("/admininduk?page=data-sampah")

    logo = f"/{getdatacabang(user_data['nama'])['logo']}"
    return render_template("tambah-sampah.html", user_data=user_data, logo=logo)
@app.route("/setor/<string:id>", methods=["GET", "POST"])
def setor(id):
    user_data = verify_session()
    if not user_data or user_data["level"] not in ["induk", "cabang"]:
        abort(404)  # Cegah akses jika bukan admin induk

    user_data["nik"] = id
    logo = f"/{getdatacabang(user_data['nama'])['logo']}"
    sampah_list = getallsampah()
    if request.method == "POST":
        id_nasabah = request.form.get("nik")
        cabang = request.form.get("cabang")  # Ambil data cabang dari session
        data_setor = []

        # Ambil semua input sebagai list
        form_data = request.form.to_dict(flat=False)
        
        try:
            # Loop untuk mengambil semua data dari form
            jenis_sampah = form_data.get("jenis_sampah", [])
            harga = form_data.get("harga", [])
            jumlah = form_data.get("jumlah", [])

            if not jenis_sampah or not harga or not jumlah:
                if user_data["level"] == "induk":
                    flash("Form tidak boleh kosong!", "danger")
                    return redirect("/admininduk?page=data-setor")
                else:
                    flash("Form tidak boleh kosong!", "danger")
                    return redirect("/admin?page=data-setor")

            for i in range(len(jenis_sampah)):
                if not jumlah[i].strip() or not harga[i].strip():
                    if user_data["level"] == "induk":
                        flash("Form tidak boleh kosong!", "danger")
                        return redirect("/admininduk?page=data-setor")
                    else:
                        flash("Form tidak boleh kosong!", "danger")
                        return redirect("/admin?page=data-setor")

                data_setor.append({
                    "jenis": jenis_sampah[i],
                    "satuan": "kg",  # Bisa diubah jika ada satuan lain
                    "jumlah": float(jumlah[i]),
                    "harga": float(harga[i])
                })

            # Kirim data ke fungsi setor sampah
            response = setorsampahnasabah(id_nasabah, cabang, data_setor)

            if "error" in response:
                flash(response["error"], "danger")
            else:
                flash("Data setor berhasil ditambahkan!", "success")

            if user_data["level"] == "induk":
                return redirect("/admininduk?page=data-setor")
            else:
                return redirect("/admin?page=data-setor")
            

        except ValueError:
            flash("Pastikan jumlah dan harga berupa angka!", "danger")
            if user_data["level"] == "induk":
                return redirect("/admininduk?page=data-setor")
            else:
                return redirect("/admin?page=data-setor")

    # Jika GET, render halaman setor.html
    return render_template("setor.html", user_data=user_data, sampah_list=list(enumerate(sampah_list)), logo=logo)
@app.route("/tarik-uang/<string:code>", methods=["POST"])
def tarik_uang(code):
    user_data = verify_session()
    if not user_data or user_data["level"] not in ["induk", "cabang"]:
        abort(404)

    response = tariksaldo(code,user_data["nama"])

    if "error" in response:
        if user_data["level"] == "induk":
            flash(response["error"], "danger")
            return redirect("/admininduk?page=data-tarik")
        else:
            flash(response["error"], "danger")
            return redirect("/admin?page=data-tarik")
    else:
        flash("Penarikan berhasil!", "success")

    if user_data["level"] == "induk":
        return redirect("/admininduk?page=data-tarik")
    else:
        return redirect("/admin?page=data-tarik")
@app.route("/detail-admin/<string:cabang>", methods=["GET"])
def detail_admin(cabang):
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        abort(404)

    data = getadminaset(cabang)
    logo = f"/{getdatacabang(user_data['nama'])['logo']}"  # Pastikan path absolut
    print(logo)  # Cek apakah path sudah benar

    return render_template("detail-admin.html", user_data=user_data, data=data, cabang=cabang, logo=logo)

@app.route("/admininduk")
def admininduk():
    """Dashboard Admin Induk"""
    user_data = verify_session()
    if not user_data or user_data["level"] != "induk":
        flash("Anda harus login sebagai admin!")
        return redirect("/login")
    
    data = getadmin(user_data["id"])
    # print(data)
    logo = data["logo"]
    # print(logo)
    page = request.args.get('page', 'data-induk')  # Default halaman
    
    # Cek apakah ada parameter 'code' di URL
    code_page = request.args.get('code', '')  
    code = ""
    if code_page:
        # ubah code_page menjadi uppercase
        code_page = code_page.upper()
        code = getcode(code_page, data["nama"])  # Ambil data berdasarkan code
        data = getalltariknasabah()  # Ambil data tarik
        print(code)
        return render_template("data-tarik.html", user_data=user_data, page=page, data=list(enumerate(data)), code=code, logo=logo)

    # Routing berdasarkan nilai 'page'
    if page == 'data-induk':
        return render_template("data-induk.html", user_data=user_data, page=page, data=data, logo=logo)
    if page == 'data-cabang':
        data = getalladmin()
        return render_template("data-cabang.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'data-nasabah-a':
        data = getnasabahbycabang(user_data["nama"])
        return render_template("data-nasabah-a.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'data-sampah':
        data = getallsampah()
        return render_template("data-sampah.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == "data-setor":
        nasabah = getnasabahbycabang(data["nama"])
        data = getallsetornasabah()
        return render_template("data-setor.html", user_data=user_data, page=page, nasabah=list(enumerate(nasabah)), data=list(enumerate(data)), logo=logo)
    if page == "data-tarik":
        data = getalltariknasabah()
        return render_template("data-tarik.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == "histori-admin-setor":
        data = getallsetoradmin()
        return render_template("histori-admin-setor.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'data-report':
        data = getgrafiksetornasabah(user_data["nama"]) or []
        data2 = getgrafiksetor() or []  # Pastikan data2 diisi

        print("Data1:", data)  # Debugging
        print("Data2:", data2)  # Debugging

        return render_template("grafik-induk.html", user_data=user_data, page=page, 
                            data=list(enumerate(data)), data2=list(enumerate(data2)), logo=logo)

    return render_template("data-induk.html", user_data=user_data, page=page, data=data, logo=logo)

@app.route("/admin-setor-view", methods=["GET", "POST"])
def setor_admin_view():
    user_data = verify_session()
    if not user_data or user_data["level"] != "cabang":
        abort(404)

    aset = getadminaset(user_data["nama"])
    # print(aset)

    # Jika aset error "Data Aset Kosong!", buat stok 0, tetapi tetap lanjut render
    if isinstance(aset, dict) and aset.get("error") == "Data Aset Kosong!":
        aset = []  # Kosongkan aset agar stok default tetap 0
    elif isinstance(aset, dict) and "error" in aset:
        flash(aset["error"], "danger")
        return redirect("/admin?page=admin-setor")

    # Pastikan aset adalah list
    if not isinstance(aset, list):
        aset = []

    sampah_list = getallsampah()

    # Set semua stock ke 0 sebagai default
    for j in sampah_list:
        j["stock"] = 0

    # Perbarui stock hanya jika jenisnya ada di aset
    for i in aset:
        for j in sampah_list:
            if i.get("jenis") == j.get("jenis"):
                j["stock"] = i.get("jumlah", 0)  # Jika tidak ada jumlah, set 0

    logo = f"/{getdatacabang(user_data['nama'])['logo']}"

    if request.method == "POST":
        data_setor = []

        # Ambil semua input sebagai list
        form_data = request.form.to_dict(flat=False)

        try:
            # Ambil data dari form
            jenis_sampah = form_data.get("jenis_sampah", [])
            harga = form_data.get("harga", [])
            jumlah = form_data.get("jumlah", [])

            # Cek apakah form kosong
            if not (jenis_sampah and harga and jumlah):
                flash("Form tidak boleh kosong!", "danger")
                return redirect("/admin?page=admin-setor")

            for idx in range(len(jenis_sampah)):
                # Pastikan input tidak kosong
                if not jumlah[idx].strip() or not harga[idx].strip():
                    flash("Form tidak boleh kosong!", "danger")
                    return redirect("/admin?page=admin-setor")

                # Konversi nilai ke float
                try:
                    jumlah_float = float(jumlah[idx])
                    harga_float = float(harga[idx])
                except ValueError:
                    flash("Pastikan jumlah dan harga berupa angka!", "danger")
                    return redirect("/admin?page=admin-setor")

                # Cek apakah stok cukup
                stok_tersedia = next((item["jumlah"] for item in aset if item["jenis"] == jenis_sampah[idx]), 0)
                if jumlah_float > stok_tersedia:
                    flash(f"Jumlah sampah {jenis_sampah[idx]} melebihi stok yang tersedia!", "danger")
                    return redirect("/admin?page=admin-setor")

                # Tambahkan ke daftar setor
                data_setor.append({
                    "jenis": jenis_sampah[idx],
                    "satuan": "kg",
                    "jumlah": jumlah_float,
                    "harga": harga_float
                })

            # Kirim data ke fungsi setor sampah
            response = setorsampahadmin(user_data["nama"], data_setor)

            if "error" in response:
                flash(response["error"], "danger")
            else:
                flash("Data setor berhasil ditambahkan!", "success")

            return redirect("/admin?page=admin-setor")

        except Exception as e:
            flash(f"Terjadi kesalahan: {str(e)}", "danger")
            return redirect("/admin?page=admin-setor")

    return render_template("setor-admin-view.html", user_data=user_data, sampah_list=list(enumerate(sampah_list)), logo=logo)

@app.route("/ubah-password/<string:page>/id/<string:id>/nama/<string:nama>", methods=["GET", "POST"])
def ubah_password(page, id, nama):
    user_data = verify_session()
    if not user_data:
        abort(404)

    if user_data["level"] not in ["induk", "cabang"]:
        abort(404)

    if request.method == "POST":
        password = request.form["password"]

        # Tentukan redirect URL dengan elif agar tidak salah
        if user_data["level"] == "cabang" and page == "nasabah":
            redirect_url = "/admin?page=data-nasabah-c"
        elif user_data["level"] == "induk" and page == "cabang":
            redirect_url = "/admininduk?page=data-cabang"
        elif user_data["level"] == "induk" and page == "nasabah":
            redirect_url = "/admininduk?page=data-nasabah-a"
        else:
            redirect_url = "/logout"

        # Update password sesuai role
        if page == "nasabah":
            response = updatepasswordnasabah(id, password)
        elif page == "cabang":
            if user_data["level"] != "induk":
                abort(404)
            response = updatepassword(id, password)
        else:
            abort(404)

        # Flash message berdasarkan respons
        if "error" in response:
            flash(response["error"], "danger")
        else:
            flash("Password berhasil diubah!", "success")
            if user_data["id"] == id:
                return redirect("/logout")  # Logout jika password admin sendiri diubah

            return redirect(redirect_url)

    # Perbaiki pengambilan logo agar tidak menyebabkan KeyError
    cabang_data = getdatacabang(user_data["nama"])
    logo = f"/{cabang_data.get('logo', 'default_logo.png')}"  # Pakai logo default jika tidak ada

    return render_template("ubah-password.html", user_data=user_data, nama=nama, logo=logo)



@app.route("/admin")
def admin():
    """Dashboard Admin"""
    user_data = verify_session()
    if not user_data or user_data["level"] != "cabang":
        flash("Anda harus login sebagai admin!")
        return redirect("/login")
    
    data = getadmin(user_data["id"])
    logo = data["logo"]
    page = request.args.get('page', 'data-cabang-c')

    code_page = request.args.get('code', '')
    code = ""
    if code_page:
        code_page = code_page.upper()
        code = getcode(code_page, data["nama"])
        data = get_riwayat_tarik_nasabah(user_data["nama"])
        return render_template("data-tarik-c.html", user_data=user_data, page=page, data=list(enumerate(data)), code=code, logo=logo)

    if page == 'data-cabang-c':
        data = getadmin(user_data["id"])
        return render_template("data-cabang-c.html", user_data=user_data, page=page, data=data, logo=logo)
    if page == 'data-nasabah-c':
        data = getnasabahbycabang(data["nama"])
        return render_template("data-nasabah-c.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'data-sampah':
        data = getallsampah()
        return render_template("data-sampah-c.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'data-setor':
        nasabah = getnasabahbycabang(data["nama"])
        data = get_riwayat_setor_nasabah(data["nama"])
        return render_template("data-setor-c.html", user_data=user_data, page=page, data=list(enumerate(data)), nasabah=list(enumerate(nasabah)), logo=logo)
    if page == 'data-tarik':
        data = get_riwayat_tarik_nasabah(data["nama"])
        return render_template("data-tarik-c.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'admin-setor':
        data = get_riwayat_setor_cabang(data["nama"])
        return render_template("setor-admin.html", user_data=user_data, page=page, data=list(enumerate(data)), logo=logo)
    if page == 'data-report':
        data = getgrafiksetornasabah(user_data["nama"]) or []
        data2 = getgrafiksetorcabang(user_data["nama"]) or []  # Pastikan data2 diisi

        print("Data1:", data)  # Debugging
        print("Data2:", data2)  # Debugging

        return render_template("grafik-cabang.html", user_data=user_data, page=page, 
                            data=list(enumerate(data)), data2=list(enumerate(data2)), logo=logo)




    return render_template("data-cabang-c.html", user_data=user_data, page=page, data=data, logo=logo)

def verify_session():
    """Memeriksa apakah user memiliki sesi login dengan JWT yang valid."""
    token = session.get("jwt")
    if not token:
        return None

    user_data = verify_jwt(token)
    if isinstance(user_data, str):  # Jika JWT invalid atau expired
        return None

    return user_data

@app.route("/logout")
def logout():
    """Menghapus sesi login."""
    session.pop("jwt", None)
    flash("Anda berhasil logout!", "success")
    return redirect("/login")

@app.route('/uploads/<path:filename>')
def serve_uploads(filename):
    user_data = verify_session()
    if 'ktp' in filename and user_data["level"] not in ["induk", "cabang"]:
        return "Forbidden", 403

    return send_from_directory('uploads', filename)

if __name__ == "__main__":
    app.run(debug=True)
